import numpy as np
from numpy import exp, abs, angle
import random as rd

def cart2pol(x, y):
    rho = np.sqrt(x**2 + y**2)
    phi = np.arctan2(y, x)
    return(rho, phi)

def pol2cart(rho, phi):
    x = rho * np.cos(phi)
    y = rho * np.sin(phi)
    return(x, y)

def euclidean(u, v):
   return( np.sqrt((u[0] - v[0])**2 + (u[1] - v[1])**2) )

def placeShapeInRing(balls, inner_circle, outer_circle, stimulus_radius):
    # try random position until the new ball does not overlap 
    # with the previous ones:
    accepted = False
    while not accepted: 
        eccentricity = rd.uniform(inner_circle, outer_circle)
        direction = rd.uniform(0, 360)
        x, y = pol2cart(eccentricity, direction)
        xj = 0
        if len(balls) < 1:
            accepted = True # no risk of overlap
        else:
            accepted = True # it is considered accepted until proven false
            for j in xrange(len(balls)):
                [xj, yj, zj] = balls[j].getPosition() # FIXME: CHECK THIS LINE
                distance = euclidean([xj, yj], [x, y]);
                if distance < 2*stimulus_radius:
                    accepted = False    # there is an overlap
                    break               # so we give up on this (x, y) proposal                
    return (x, y)
    